<?php
function getChannels()
{
   //channels
   $sock = Login();
   /* PARAMS GETTERS */
   $getterVideo = ParamGet($sock, "video");
   $getterAudio = ParamGet($sock, "audio");
   $getterServer = ParamGet($sock, "server");
   $getterCamStatInfo = ParamGet($sock, "CamStatInfo");
   $getterSecurity = ParamGet($sock, "security");

   /* data */
   global $UserId;
   $arr = [];
   $stat = isset($getterCamStatInfo->CamStatInfo) ? $getterCamStatInfo->CamStatInfo : [];
   $cameras = [];
   $i = -1;
   /* set title name */
   $serverNameTitle = isset($getterServer->server) ? getName($getterServer->server) : "Видеосервер";
   $serverTitle = urlencode($serverNameTitle);
   header("Title: " . $serverTitle);
   /* set audio array for cameras  */
   $audioArray = isset($getterAudio->audio->input) ? $getterAudio->audio->input : [];
   /* generage channels list */
   $isExistIpcams = true;
   if (isset($getterVideo->video->ipcams) && $getterVideo->video->ipcams <= $getterVideo->video->inputs) {
      $inputs_count = $getterVideo->video->ipcams;
   } else {
      $inputs_count = $getterVideo->video->inputs;
      $isExistIpcams = false;
   }

   if (!isset($getterVideo->video->input) && !$isExistIpcams) {
      return [];
   }

   if (isset($getterVideo->video->input)) {
      $arr = $getterVideo->video->input;
   } else {
      for ($i = 0; $i < $inputs_count; $i++) {
         $arr[$i] = ["index" => $i, "enabled" => 0];
      }
   }

   $arr = sort_nested_arrays($arr, ["index" => "desc"]);
   $arr = fillEmptyChannels($arr, $inputs_count, $isExistIpcams);
   $arr = array_slice($arr, 0, $inputs_count);

   /* user info */
   $user = GetUserById($UserId, $getterSecurity);
   $accessChannels = getDenyAccess($user);
   /* check array count */
   if (!isset($arr) || count($arr) === 0) {
      socket_close($sock);
      return $cameras;
   }
   /* generage list channels */
   foreach ($arr as $obj) {
      $i++;
      if (!isset($obj) || !isset($obj->index)) {
         $cameras[$i]["index"] = $i;
         $cameras[$i]["enabled"] = 0;
         continue;
      }
      if ($accessChannels["read"][$i] != 0) {
         continue;
      }

      $names["index"] = $obj->index;
      $names = json_decode("{}", true);
      $names["access"] = [
         "read" => !$accessChannels["read"][$i] ?? false,
         "write" => !$accessChannels["write"][$i] ?? false,
         "play" => !$accessChannels["play"][$i] ?? false,
         "ptz" => !$accessChannels["ptz"][$i] ?? false,
         "soundRead" => !$accessChannels["soundRead"][$i] ?? false,
         "soundPlay" => !$accessChannels["soundPlay"][$i] ?? false,
      ];
      $names["accessLevel"] = isset($arr[$i]->access)
         ? (object) cutAccess($arr[$i]->access)
         : (object) ["read" => 1, "write" => 1, "play" => 1, "ptz" => 1, "soundRead" => 1, "soundPlay" => 1];
      $names["name"] = getNameChannel($obj);
      $names["index"] = $obj->index;
      $names["mediatype"] = isset($obj->mediatype) ? $obj->mediatype : 0;
      $names["enabled"] = isset($obj->enabled) ? boolval($obj->enabled) : false;
      $names["imagetransformation"] = isset($obj->imagetransformation) ? $obj->imagetransformation : 0;
      $audio = getAudioPropsByArray($audioArray, $i); //
      /* for multisettings */
      $names["ip"] = isset($obj->ip) ? $obj->ip : "192.168.0.0";
      $names["portOnvif"] = isset($obj->portOnvif) ? $obj->portOnvif : 80;
      if (isset($obj->port2)) {
         $names["port2"] = $obj->port2;
      }
      $names["url"] = isset($obj->url) ? $obj->url : "";
      $names["url2"] = isset($obj->url2) ? $obj->url2 : "";
      $names["username"] = isset($obj->username) ? $obj->username : "";
      $names["gpio"] = isset($obj->gpio) ? $obj->gpio : "";
      $names["port_rtsp"] = isset($obj->port) ? intval($obj->port) : "";
      $names["rtsp"] = isset($obj->usetcp) && $obj->usetcp == 1 ? "TCP" : "UDP";
      $names["virgin"] = isset($obj->ip) ? false : true;
      $names["timeout"] = isset($obj->timeout) ? $obj->timeout : 1;
      $names["sound"] = isset($audio->enabled) ? boolval($audio->enabled) : false;
      $names["ptz"] = isset($obj->ptz) && isset($obj->ptz->ipptz) ? boolval($obj->ptz->ipptz) : false;
      $names["timezones"] = [];
      $names["timezones"] = getTimeZones($getterServer, $getterAudio, $obj);
      /* INTEGRATION-OPTIONS */
      $names["va_rec_timeshift"] = isset($obj->va_rec_timeshift) ? $obj->va_rec_timeshift : "";
      $names["ivibrmoid"] = isset($obj->ivibrmoid) ? tryConvert($obj->ivibrmoid) : "";
      $names["geolat"] = isset($obj->geolat) ? $obj->geolat : "";
      $names["geolon"] = isset($obj->geolon) ? $obj->geolon : "";
      $names["titleshort"] = isset($obj->titleshort) ? tryConvert($obj->titleshort) : "";
      $names["homeaddress"] = isset($obj->homeaddress) ? tryConvert($obj->homeaddress) : "";
      $names["location1251"] = isset($obj->location1251) ? $obj->location1251 : "";
      $names["districtName"] = isset($obj->districtName) ? tryConvert($obj->districtName) : "";
      $names["cameraTypeName"] = isset($obj->cameraTypeName) ? tryConvert($obj->cameraTypeName) : "";
      /*  */
      if (isset($obj->cammodel)) {
         $names["cammodel"] = $obj->cammodel;
      }
      $names["signal"] = checkSignal($stat, $names["index"]);
      $names["codec"] = getCodec($stat, $names["index"]);
      $names["codec"][1] = isset($obj->url2) ? $names["codec"][1] : 0;
      $names["stream2"] = isset($obj->url2);
      $names["gpio"] = isset($obj->gpio) ? $obj->gpio : "";
      $names["mediatype"] = isset($obj->mediatype) ? $obj->mediatype : 0;
      if (!isset($names["accessLevel"]->soundRead) && isset($audio->access)) {
         if (isset($audio->access->read)) {
            $read = $audio->access->read;
            if (10 % $read >= 10 && $read < 101) {
               $names["accessLevel"]->soundRead = $read / 10;
            } elseif ($read == 10) {
               $names["accessLevel"]->soundRead = 1;
            } elseif ($read == 101) {
               $names["accessLevel"]->soundRead = 11;
            } else {
               $names["accessLevel"]->soundRead = $read;
            }
         } else {
            $names["accessLevel"]->soundRead = 1;
         }
      }
      if (!isset($names["accessLevel"]->soundPlay) && isset($audio->access)) {
         if (isset($audio->access->play)) {
            $play = $audio->access->play;
            if (10 % $play >= 10 && $play < 101) {
               $names["accessLevel"]->soundPlay = $play / 10;
            } elseif ($play == 10) {
               $names["accessLevel"]->soundPlay = 1;
            } elseif ($play == 101) {
               $names["accessLevel"]->soundPlay = 11;
            } else {
               $names["accessLevel"]->soundPlay = $play;
            }
         } else {
            $names["accessLevel"]->soundPlay = 1;
         }
      }
      if (!isset($audio->access)) {
         $names["accessLevel"] = (object) [
            "read" => 1,
            "write" => 1,
            "play" => 1,
            "ptz" => 1,
            "soundRead" => 1,
            "soundPlay" => 1,
         ];
      } else {
         if (!isset($names["accessLevel"]->read)) {
            $names["accessLevel"]->read = 1;
         }
         if (!isset($names["accessLevel"]->write)) {
            $names["accessLevel"]->write = 1;
         }
         if (!isset($names["accessLevel"]->play)) {
            $names["accessLevel"]->play = 1;
         }
         if (!isset($names["accessLevel"]->ptz)) {
            $names["accessLevel"]->ptz = 1;
         }
      }
      array_push($cameras, $names);
   }
   socket_close($sock);
   return $cameras;
}
function getChannel($id)
{
   //channels/1
   global $UserId;
   $sock = Login();
   //смотрим на соответствие
   $index = intval($id);
   /* getters data */
   $getterAudio = ParamGet($sock, "audio");
   $getterServer = ParamGet($sock, "server");
   $getterVideo = ParamGet($sock, "video");
   $getterSecurity = ParamGet($sock, "security");
   $getterCamStatInfo = ParamGet($sock, "CamStatInfo");
   /* data */
   if (isset($getterVideo->video->input)) {
      $channel = findChannel($getterVideo->video->input, $index);
      $user = GetUserById($UserId, $getterSecurity);

      if (isset($user->deny) && isset($user->deny->camera)) {
         $read = checkCameraDeny_read($user);
         if (!isset($read[$index]) || $read[$index] == 1) {
            Header("502 Bad Gateway");
         }
      }

      $stat = $getterCamStatInfo->CamStatInfo;
      $ar = [];
      $statFinal = false;
      $i = intval($index);
      $i++;

      foreach ($stat as $s) {
         array_push($ar, $s->id);
         if ($s->id == $i) {
            $statFinal = $s;
         }
      }

      $json = json_decode("{}", true);
      $json["stat"] = $statFinal; // статистика по камерам
      $json["index"] = $index;
      $json["enabled"] = isset($channel->enabled)
         ? (gettype($channel->enabled) == "integer"
            ? $channel->enabled == 1
            : $channel->enabled)
         : false;
      $json["ip"] = isset($channel->ip) ? $channel->ip : "192.168.0.0";
      $json["virgin"] = isset($channel->ip) ? false : true;
      $json["portOnvif"] = isset($channel->portOnvif) ? $channel->portOnvif : 80;
      if (isset($channel->port2)) {
         $json["port2"] = $channel->port2;
      }
      $json["gpio"] = isset($channel->gpio) ? $channel->gpio : "";
      $json["chain"] = isset($channel->ptz->onviftourtoken) ? $channel->ptz->onviftourtoken : false;
      $json["username"] = isset($channel->username) ? $channel->username : "";
      $json["cam_password"] = "";
      if (isset($channel->cammodel)) {
         $json["cammodel"] = $channel->cammodel;
      }
      $json["onvif_password"] = isset($channel->cam_password) ? $channel->cam_password : "";
      $json["mediaType"] = isset($channel->mediatype) ? $channel->mediatype : 82;
      $json["port_rtsp"] = isset($channel->port) ? intval($channel->port) : "";
      $json["url"] = isset($channel->url) ? $channel->url : "";
      $json["title"] = getNameChannel($channel);
      $json["gpio"] = isset($channel->gpio) ? $channel->gpio : "";

      $json["url2"] = isset($channel->url2) ? $channel->url2 : "";
      $json["imagetransformation"] = isset($channel->imagetransformation) ? $channel->imagetransformation : 0;
      $json["timeout"] = isset($channel->timeout) ? $channel->timeout : 1;
      $json["ptz"] =
         isset($channel->ptz) && isset($channel->ptz->ipptz) ? boolval($channel->ptz->ipptz) : false; // пока что ставим просто 1
      /* INTEGRATION-OPTIONS */
      $json["va_rec_timeshift"] = isset($channel->va_rec_timeshift)
         ? tryConvert($channel->va_rec_timeshift)
         : "";
      $json["ivibrmoid"] = isset($channel->ivibrmoid) ? tryConvert($channel->ivibrmoid) : "";
      $json["geolat"] = isset($channel->geolat) ? $channel->geolat : "";
      $json["geolon"] = isset($channel->geolon) ? $channel->geolon : "";
      $json["titleshort"] = isset($channel->titleshort) ? tryConvert($channel->titleshort) : "";
      $json["homeaddress"] = isset($channel->homeaddress) ? tryConvert($channel->homeaddress) : "";
      $json["location1251"] = isset($channel->location1251) ? $channel->location1251 : ""; // iconv ('utf-8', 'windows-1251', $string);
      $json["districtName"] = isset($channel->districtName) ? tryConvert($channel->districtName) : "";
      $json["cameraTypeName"] = isset($channel->cameraTypeName) ? tryConvert($channel->cameraTypeName) : "";
      /*  */
      $json["rtsp"] = isset($channel->usetcp) && $channel->usetcp == 1 ? "TCP" : "UDP";
      $audio = getAudioProperties($getterAudio, $index);
      $json["audio"] = isset($audio->enabled) ? boolval($audio->enabled) : false;
      $json["timezones"] = getTimeZones($getterServer, $getterAudio, $channel); // getTimeZones($sock, $channel, $index);
      $json["codec"] = getCodec($stat, $index);
      $json["codec"][1] = isset($channel->url2) ? $json["codec"][1] : 0;
      socket_close($sock);
      return $json;
   }

   $json = json_decode("{}", true);
   $json["index"] = $index;
   $json["enabled"] = 0;
   $json["virgin"] = true;
   $json["ip"] = "192.168.0.0";
   $timezones = [];
   if (isset($getterServer->server->timezone)) {
      $timezones = $getterServer->server->timezone;
   } else {
      $timezones == [["index" => 3, "start" => "00:00:00", "state" => 0]];
   }
   $count_zones = 0;
   $zone_index = 0;
   foreach ($timezones as $zone) {
      //считаем количество активных зон
      $zone_index += $zone->state;
   }
   foreach ($timezones as $zone) {
      //конвертиртируем начало и конец в нормальный вариант
      foreach ($zone as $key => $value) {
         $zone->audio = isset($zone->audio) ? boolval($zone->audio) : false;
         $zone->va_rec = isset($zone->va_rec) ? boolval($zone->va_rec) : false;
         if ($zone->state != 0 && $key == "start" && $zone_index < $count_zones - 1) {
            $zone->start = $value;
            $timezones[$zone_index]->end = $timezones[$zone_index + 1]->start - 1;
         } elseif ($timezones[1]->state != 0 && $zone->index == 2 && $zone->state == 0) {
            $timezones[1]->end = $timezones[3]->start - 1;
         } elseif ($key == "start" && $zone_index == count($timezones) - 1) {
            $zone->start = $value;
            $timezones[$zone_index]->end = $timezones[0]->start - 1;
         }
      }
      $zone_index++;
   }

   $json["timezones"] = [];
   for ($i = 0; $i < count($timezones); $i++) {
      if ($timezones[$i]->state == 1) {
         array_push($json["timezones"], [
            "audio" => false,
            "va_rec" => false,
            "detskip" => -1,
            "alarmdelay" => 0,
            "motionskip" => -1,
            "prevrectime" => 0,
            "end" => $timezones[$i]->end,
            "start" => $timezones[$i]->start,
         ]);
      }
   }

   socket_close($sock);
   return $json;
}

function getSignal($id)
{
   //channels/1/signal
   $sock = Login();
   $timeout = 15;
   $counter = 0;
   do {
      $stat = ParamGet($sock, "CamStatInfo");
      $stat = $stat->CamStatInfo;
      $cameras = array_filter($stat, function ($cam) use ($id) {
         return $cam->id == $id;
      });
      if (count($cameras) == 0) {
         sleep(1);
         $counter += 1;
         continue;
      }
      $camera = [];
      foreach ($cameras as $key => $value) {
         $camera = (object) $value;
      }
      if ($camera->fps[0] != 0 || $camera->fps[1] != 0) {
         return true;
         die();
      } else {
         sleep(1);
         $counter += 1;
         continue;
      }
   } while ($counter <= $timeout); // через каждую 1 секунду до timeout секунд
   return false;
}
function getStatistics($id)
{
   //channels/1/statistics
   $sock = Login();
   $stat = ParamGet($sock, "CamStatInfo");
   $stat = isset($stat->CamStatInfo) ? $stat->CamStatInfo : [];
   $statFinal = false;

   if (count($stat) == 0) {
      socket_close($sock);
      return $statFinal;
   }

   $i = intval($id) + 1;

   foreach ($stat as $s) {
      if ($s->id == $i) {
         $statFinal = $s;
         break;
      }
   }
   socket_close($sock);
   return $statFinal;
}
function getCameras()
{
   $sock = Login();
   $arr = ParamGet($sock, "video");
   if (!isset($arr->video->input)) {
      $arr->video->input = false;
      socket_close($sock);
      return $arr->video;
   }

   $isExistIpcams = true;
   $count = 0; // проверка на кол-во камер, для отображения
   if (isset($arr->video->ipcams) && $arr->video->ipcams <= $arr->video->inputs) {
      $count = $arr->video->ipcams; // выбранное кол-во каналов на основе правил, что есть инф о кол-ве камер выбранных клиентом и также оно не превышает доступное на серве
   } else {
      $count = $arr->video->inputs; // берем макс. доступное
      $isExistIpcams = false;
   }

   $arr->video->input = sort_nested_arrays($arr->video->input, ["index" => "desc"]); // сортировка по индексу 0-128
   $arr->video->input = fillEmptyChannels($arr->video->input, $count, $isExistIpcams); // генерация каналов без данных
   $arr->video->input = array_slice($arr->video->input, 0, $count); // берут огранич кол-во каналов, по данным сервера
   $arr->video->input = getNeedProps($arr->video->input, ["index", "title1251", "access"]);

   foreach ($arr->video->input as $cam) {
      if (!isset($cam["access"])) {
         $arr->video->input[$cam["index"]]["access"]["read"] = 1;
         $arr->video->input[$cam["index"]]["access"]["write"] = 1;
         $arr->video->input[$cam["index"]]["access"]["play"] = 1;
         $arr->video->input[$cam["index"]]["access"]["ptz"] = 1;
         $arr->video->input[$cam["index"]]["access"]["soundRead"] = 1;
         $arr->video->input[$cam["index"]]["access"]["soundPlay"] = 1;
      } else {
         if (!isset($arr->video->input[$cam["index"]]["access"]->ptz)) {
            $arr->video->input[$cam["index"]]["access"]->ptz = isset(
               $arr->video->input[$cam["index"]]["access"]->read
            )
               ? $arr->video->input[$cam["index"]]["access"]->read
               : 1;
         }
      }
   }
   $sounds = audioAccess($sock, $arr->video->inputs);
   $sounds = array_slice($sounds, 0, $count);
   foreach ($sounds as $sound) {
      $index = is_array($sound) ? $sound["index"] : $sound->index;
      $valuRead = isset($sound->access) && isset($sound->access->read) ? $sound->access->read : 1;
      $valuPlay = isset($sound->access) && isset($sound->access->play) ? $sound->access->play : 1;
      if (is_array($arr->video->input[$index]["access"])) {
         $arr->video->input[$index]["access"]["soundRead"] = $valuRead;
         $arr->video->input[$index]["access"]["soundPlay"] = $valuPlay;
      } else {
         $arr->video->input[$index]["access"]->soundRead = $valuRead;
         $arr->video->input[$index]["access"]->soundPlay = $valuPlay;
      }
   }
   socket_close($sock);
   return $arr->video;
}
function getChannelsAccess()
{
   global $UserId;
   $sock = Login();

   $arr = "";
   $arr = ParamGet($sock, "video");
   if (isset($arr->video->ipcams) && $arr->video->ipcams <= $arr->video->inputs) {
      $inputs_count = $arr->video->ipcams;
   } else {
      $inputs_count = $arr->video->inputs;
   }
   if (isset($arr->video->input)) {
      $arr = $arr->video->input;
   } else {
      $inputs = $arr->video->inputs;
      $input = [];
      $arr->video->input = $input;
      $arr = $arr->video->input;

      for ($i = 0; $i < $inputs_count; $i++) {
         $cam = ["index" => $i, "enabled" => 0];

         $arr[$i] = $cam;
      }
   }
   $data = "{}";
   $cameras = [];
   $arr = sort_nested_arrays($arr, ["index" => "desc"]);

   $arr = array_slice($arr, 0, $inputs_count); //ограничиваем количество камер исходя из значения video->ipcams
   $i = 0;
   $security = ParamGet($sock, "security");
   $user = GetUserById($UserId, $security); // fix
   $accessChannels = getDenyAccess($user); // fix
   $audioArray = ParamGet($sock, "audio");
   foreach ($arr as $obj) {
      $names = json_decode($data, true);
      $names["index"] = $obj->index;
      $access = [
         "read" => !$accessChannels["read"][$i],
         "write" => !$accessChannels["write"][$i],
         "play" => !$accessChannels["play"][$i],
         "ptz" => !$accessChannels["ptz"][$i],
         "soundRead" => !$accessChannels["soundRead"][$i],
         "soundPlay" => !$accessChannels["soundPlay"][$i],
      ];
      $names["access"] = $access;
      if (isset($arr[$i]->access)) {
         $names["accessLevel"] = cutAccess($arr[$i]->access); // fix
         $audio = getAudioProperties($audioArray, $i);
         if (!isset($names["accessLevel"]->soundRead)) {
            if (10 % $audio->access->read >= 10 && $audio->access->read < 101) {
               $names["accessLevel"]->soundRead = $audio->access->read / 10;
            } elseif ($audio->access->read == 101) {
               $names["accessLevel"]->soundRead = 11;
            } else {
               $names["accessLevel"]->soundRead = $audio->access->read;
            }
         }
         if (!isset($names["accessLevel"]->soundPlay)) {
            if (10 % $audio->access->play >= 10 && $audio->access->play < 101) {
               $names["accessLevel"]->soundPlay = $audio->access->play / 10;
            } elseif ($audio->access->play == 101) {
               $names["accessLevel"]->soundPlay = 11;
            } else {
               $names["accessLevel"]->soundPlay = $audio->access->play;
            }
         }
      } else {
         $names["accessLevel"] = [
            "read" => 1,
            "write" => 1,
            "play" => 1,
            "ptz" => 1,
            "soundRead" => 1,
            "soundPlay" => 1,
         ];
      }
      array_push($cameras, $names);
      $i++;
   }
   $cameras = sort_nested_arrays($cameras, ["index" => "desc"]);
   socket_close($sock);

   return $cameras;
}
function getExpChannels()
{
   //channels
   $sock = Login();
   $arr = "";
   $obj = (object) [
      "cameras" => [],
      "audio" => [],
   ];
   $arr = ParamGet($sock, "video");
   $audioArray = ParamGet($sock, "audio");
   $isExistIpcams = true;
   if (isset($arr->video->ipcams) && $arr->video->ipcams <= $arr->video->inputs) {
      $inputs_count = $arr->video->ipcams;
   } else {
      $inputs_count = $arr->video->inputs;
      $isExistIpcams = false;
   }
   if (isset($arr->video->input)) {
      $arr = $arr->video->input;
      $arr = sort_nested_arrays($arr, ["index" => "desc"]);
      $arr = fillEmptyChannels($arr, $inputs_count, $isExistIpcams);
      $arr = array_slice($arr, 0, $inputs_count);
      $obj->cameras = $arr;
   }
   if (isset($audioArray->audio->input)) {
      $audioArray = $audioArray->audio->input;
      $audioArray = array_slice($audioArray, 0, $inputs_count);
      $obj->audio = $audioArray;
   }

   return $obj;
}
function generateTimeZones($server)
{
   $timezones = [];
   if (isset($server->server->timezone)) {
      $timezones = $server->server->timezone;
   } else {
      $timezones == [["index" => 3, "start" => "00:00:00", "state" => 0]];
   }
   $zone_index = 0;
   foreach ($timezones as $zone) {
      //считаем количество активных зон
      $zone_index += $zone->state;
   }
   foreach ($timezones as $zone) {
      //конвертиртируем начало и конец в нормальный вариант
      if (isset($timezones[$zone_index])) {
         $timezones[$zone_index]->audio = isset($timezones[$zone_index]->audio)
            ? boolval($timezones[$zone_index]->audio)
            : false;
         $timezones[$zone_index]->va_rec = isset($timezones[$zone_index]->va_rec)
            ? boolval($timezones[$zone_index]->va_rec)
            : false;
      }
      if ($timezones[1]->state != 0 && $zone->index == 2 && $zone->state == 0) {
         $timezones[1]->end = $timezones[3]->start - 1;
      } elseif ($zone_index == count($timezones) - 1) {
         $timezones[$zone_index]->end = $timezones[0]->start - 1;
      }
      $zone_index++;
   }

   $expTimezones = [];
   for ($i = 0; $i < count($timezones); $i++) {
      if ($timezones[$i]->state == 1) {
         array_push($expTimezones, [
            "audio" => false,
            "va_rec" => false,
            "detskip" => -1,
            "alarmdelay" => 0,
            "motionskip" => -1,
            "prevrectime" => 0,
            "state" => isset($timezones[$i]->state) ? $timezones[$i]->state : 0,
            "end" => isset($timezones[$i]->end) ? $timezones[$i]->end : 0,
            "start" => $timezones[$i]->start ? $timezones[$i]->start : 10800 * $i,
         ]);
      }
   }
   return $expTimezones;
}
function tryConvert($value)
{
   try {
      $str = mb_convert_encoding($value, "windows-1251", "utf-8");
      return str_replace("\xd0\x3f", "И", $str);
   } catch (Exception $e) {
      return $value;
   }
}
